<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('user_id', 'family_id', 'driver_id', 'address_id', 'payment_types', 'order_time', 'date', 'time', 'total_price', 'status', 'order_code', 'cart_total', 'tax', 'delivery_cost');

    public function address()
    {
        return $this->belongsTo('App\Models\Address', 'address_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function family()
    {
        return $this->belongsTo('User', 'family_id');
    }

    public function cancel_messages()
    {
        return $this->hasMany('App\Models\OrderCancel', 'order_id');
    }

    public function order_carts()
    {
        return $this->belongsToMany('App\Models\Order', 'order_carts', 'order_id', 'cart_id');
    }

}